#ifndef _SRSItemVal_h__
#define _SRSItemVal_h__

#include <GSTenums.h>
#include <Geometry/SRS.h>
#include <buildspec.h>
#include <config.h>

#include <boost/shared_ptr.hpp>
#include <map>
#include <string>

#include <Geometry/boost_serialize_includes.hpp>

namespace GST
{
namespace Geometry
{

struct GST_API_EXPORT SRSItemDesc : public Geometry::GSTSRSRef
{
	friend class boost::serialization::access;

	///@name members
	//@{
	std::string code_type;
	std::string code_value;
	std::string label;
	//@}

	SRSItemDesc();

	SRSItemDesc(const long &id,
				const std::string &code_type,
				const std::string &code_value,
				const std::string &label);

	virtual std::string ToString() const;

	/// boost serialization access
	template<typename Archive>
	void serialize(Archive &ar, const unsigned int version);
};
typedef boost::shared_ptr<SRSItemDesc> SRSItemDescPtr;

template<typename Archive>
void SRSItemDesc::serialize(Archive &ar, const unsigned int version)
{
	ar &boost::serialization::make_nvp(
		"base_GSTSRSRef",
		boost::serialization::base_object<Geometry::GSTSRSRef>(*this));
	ar &boost::serialization::make_nvp("code_type", this->code_type);
	ar &boost::serialization::make_nvp("code_value", this->code_value);
	ar &boost::serialization::make_nvp("label", this->label);
}

//--------------------------------------------------------------------------------------------------

class SRSItemDescList;
typedef boost::shared_ptr<SRSItemDescList> SRSItemDescListPtr;

class GST_API_EXPORT SRSItemDescList
{
public:
	typedef std::map<long, SRSItemDesc> srsmap_type;

private:
	std::map<long, SRSItemDesc> srs_list;

public:
	void append(const SRSItemDesc &desc);
	SRSItemDesc getByKey(const long &key);
	SRSItemDescListPtr getByCode(const std::string &code_value);
	SRSItemDescListPtr getByCodeType(const std::string &code);
	SRSItemDescListPtr getByName(const std::string &label);
	SRSItemDesc getByCodeAndCodeType(const std::string &code_type,
									 const std::string &code_value);
	SRSItemDesc getBySRSPtr(Geometry::SRSPtr srs);

	std::size_t size() const;
	const srsmap_type &getMap() const;
};

//--------------------------------------------------------------------------------------------------

struct GST_API_EXPORT SRSItemVal
{
	SRSItemDescPtr desc;
	std::string param;

	SRSItemVal();
	SRSItemVal(SRSItemDescPtr desc, const std::string &param);
	SRSItemVal(const long &id,
			   const std::string &code_type,
			   const std::string &code_value,
			   const std::string &label,
			   const std::string &param);
};
typedef boost::shared_ptr<SRSItemVal> SRSItemValPtr;

} // namespace Geometry
} // namespace GST

BOOST_CLASS_EXPORT_KEY(GST::Geometry::SRSItemDesc);

BOOST_CLASS_VERSION(GST::Geometry::SRSItemDesc, 1)

#endif // _SRSItemVal_h__
